// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj:ViewProjection;
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse;
   float4x4 PrevViewProj;

//--------------
// un-tweaks
//--------------
   float2 ViewScale;
   float FogRange;
   float4 VolumePosition[32];
   float4 VolumeColor[32];

//--------------
// Textures
//--------------
   texture DepthTexture <string Name = "";>;	
   sampler DepthSampler=sampler_state 
      {
 	Texture=<DepthTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
 	float2 Tex0:TEXCOORD0;
     };
   struct OutPut
     {
 	float4 Pos:POSITION;
 	float4 Proj:TEXCOORD0;
	float3 Normals:TEXCOORD1;
	float3 ViewVec:TEXCOORD2;
	float Range:TEXCOORD3;
	float4 Color:COLOR0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
    {
 	OutPut OUT;
	float4 WorldPos=VolumePosition[floor(IN.Tex0.x)];
	WorldPos.xyz +=IN.Pos.xyz*WorldPos.w*2.0;
	OUT.Pos=mul(float4(WorldPos.xyz,1),ViewProj); 
	float4 PrevPos=mul(float4(WorldPos.xyz,1.0),PrevViewProj);
	OUT.Proj=float4(PrevPos.x*0.5+0.5*PrevPos.w,0.5*PrevPos.w-PrevPos.y*0.5,(OUT.Pos.z*0.5)-(WorldPos.w*0.25),PrevPos.w);
	OUT.Normals=IN.Pos.xyz;
	OUT.ViewVec=ViewInv[3].xyz-WorldPos.xyz;
	OUT.Range=WorldPos.w*0.5;
	OUT.Color=VolumeColor[floor(IN.Tex0.x)];
	OUT.Color.xyz *=OUT.Color.w;
	OUT.Color.xyz *=saturate(exp(-((OUT.Pos.z*0.5)/FogRange)));
	return OUT;
    }

//--------------
// pixel shader
//--------------
    float4 PS(OutPut IN)  : COLOR
     {
	float Depth=tex2D(DepthSampler,(IN.Proj.xy/IN.Proj.w)+ViewScale).w-IN.Proj.z;
	float Volume=pow(abs(dot(normalize(IN.Normals),normalize(IN.ViewVec))),5.0);
	Volume *=saturate(length(IN.ViewVec)/(IN.Range*5.0));
	return float4(IN.Color.xyz*saturate(Volume-0.025)*saturate(Depth/IN.Range),1.0);
     }

//--------------
// techniques   
//--------------
    technique LightVolume
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS(); 
 	pixelShader  = compile ps_3_0 PS();
	AlphaBlendEnable=true;
	SrcBlend=one;
 	DestBlend=one;
	zwriteenable=false;
        ColorWriteEnable=7;
	CullMode=0;
      }
      }
